//
//  TWAPICollectionViewController.h
//  Xarth
//
//  Created by Auston Stewart on 10/21/13.
//  Copyright (c) 2013 Justin.tv, Inc. All rights reserved.
//

#import <UIKit/UIKit.h>

@class TWNoContentOverlayView;

typedef enum {
	
	TWAPITableViewStyleMixed,
	TWAPITableViewStyleGrid,
	TWAPITableViewStyleList
	
} TWAPITableViewStyle;

@interface TWAPICollectionViewController : UIViewController <UITableViewDataSource,UITableViewDelegate,UICollectionViewDataSource,UICollectionViewDelegate>

@property (nonatomic, readwrite) NSUInteger limit;
@property (nonatomic, strong) NSString *referralIdentity;
@property (nonatomic, readwrite) NSInteger contentSection;
@property (nonatomic, readonly) NSInteger numberOfItemsInContentSection;
@property (nonatomic, readonly) NSMutableArray *items;
@property (nonatomic, copy) NSComparator comparator;

@property (nonatomic, readonly) NSOperationQueue *operationQueue;
@property (nonatomic, readwrite) TWAPITableViewStyle tableViewStyle;

@property (nonatomic, readwrite) BOOL displaysNoContentItem;
@property (nonatomic, readwrite) BOOL displaysMoreContentItem;
@property (nonatomic, readwrite) BOOL infiniteScrollingEnabled;
@property (nonatomic, readwrite) BOOL includeUnplayableContent;

@property (nonatomic,readonly) UICollectionView *collectionView;
@property (nonatomic,readonly) UITableView *tableView;
@property (nonatomic,readonly) TWNoContentOverlayView *noContentOverlayView;
@property (nonatomic,readonly) NSIndexPath *highlightedIndexPath;

@property (nonatomic,readonly) BOOL isDisplayingNoContentItem;
@property (nonatomic,readonly) BOOL isDisplayingMoreContentItem;
@property (nonatomic,readonly) BOOL isRequestingAdditionalItems;
@property (nonatomic,readonly) BOOL isRefreshingItems;
@property (nonatomic,readonly) BOOL isAtEndOfList;

- (id)initWithCollectionViewLayout:(UICollectionViewLayout *)layout;
- (id)initWithTableViewStyle:(TWAPITableViewStyle)style;
- (void)commonInitialization;
- (void)updateViewForContentChange;
- (void)refreshItems;
- (void)requestAdditionalItems;

- (void)requestDidFinish:(NSNotification *)notification;
- (void)requestDidFail:(NSNotification *)notification;

@end
